IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].[V_PDV_VD_MAPA_RESUMO_CX]')
)
    DROP VIEW [dbo].[V_PDV_VD_MAPA_RESUMO_CX];
GO

/*
    SELECT *  FROM V_PDV_VD_MAPA_RESUMO_CX WHERE cd_emp =1 and CD_FILIAL = 36 AND DT_MOV = '20170810' and cd_cx = 4
    SELECT *  FROM V_PDV_VD_TRIBUTOS WHERE cd_emp =1 and CD_FILIAL = 36 AND DT_VD = '20170810' and cd_cx = 4
    SELECT *  FROM V_PDV_VD_TRIBUTOS_TAXAS WHERE cd_emp =1 and CD_FILIAL = 36 AND DT_VD = '20170810' and cd_cx = 4

 */
--SELECT * FROM V_PDV_VD_MAPA_RESUMO_CX WHERE CD_EMP =1 AND CD_FILIAL = 1 AND DT_MOV='2018-05-22'
CREATE VIEW [dbo].[V_PDV_VD_MAPA_RESUMO_CX]
WITH ENCRYPTION
AS
     SELECT TEMP.CD_EMP,
            TEMP.CD_FILIAL,
            TEMP.CD_CX,
            TEMP.DT_VD AS DT_MOV,
            ISNULL(POS_ECF.CONT_REDUCAO_Z, 0) CONT_REDUCAO_Z,
            ISNULL(POS_ECF.CONT_REINICIO_OP, 0) CONT_REINICIO_OP,
            ISNULL(POS_ECF.VLR_GT_INI, 0) AS VLR_GT_INI,
            ISNULL(POS_ECF.VLR_GT_FIN, 0) AS VLR_GT_FIN,
            MIN(TEMP.COO) - 1 AS COO_INICIAL,
            MAX(TEMP.COO) + 1 AS COO_FINAL,
            ROUND(SUM(TEMP.VLR_CONTAB), 2) AS VLR_CONTAB,
            SUM(TEMP.VLR_IT_CANCEL) AS VLR_IT_CANCEL,
            SUM(TEMP.VLR_CUPONS_CANCELADOS) AS VLR_CUPONS_CANCELADOS,
            SUM(TEMP.VLR_CUPONS_CANCELADOS) + SUM(TEMP.VLR_IT_CANCEL) AS VLR_CANCELAMENTOS,
            SUM(TEMP.VLR_IT_CANCEL_ISSQN) AS VLR_IT_CANCEL_ISSQN,
            SUM(TEMP.VLR_CUPONS_CANCELADOS_ISSQN) AS VLR_CUPONS_CANCELADOS_ISSQN,
            SUM(TEMP.VLR_CUPONS_CANCELADOS_ISSQN) + SUM(TEMP.VLR_IT_CANCEL_ISSQN) AS VLR_CANCELAMENTOS_ISSQN,
            SUM(TEMP.VLR_DESC_IT) AS VLR_DESC_IT,
            SUM(TEMP.VLR_DESC) AS VLR_DESC_VD,
            SUM(TEMP.VLR_DESC_IT) + SUM(TEMP.VLR_DESC) AS VLR_DESCONTOS,
            SUM(TEMP.VLR_DESC_IT_ISSQN) AS VLR_DESC_IT_ISSQN,
            SUM(TEMP.VLR_DESC_IT_ISSQN) + SUM(TEMP.VLR_DESC_ISSQN) AS VLR_DESCONTOS_ISSQN,
            SUM(TEMP.VLR_CONTAB) - SUM(TEMP.VLR_DESC_ISSQN+TRIB.VLR_N_INCIDENCIA_ISSQN) AS VLR_VD_LIQ,
            ISNULL(TRIB.VLR_SUBST_TRIB, 0) AS VLR_SUBST_TRIB,
            ISNULL(TRIB.VLR_ISENTAS, 0) AS VLR_ISENTAS,
            ISNULL(TRIB.VLR_ISENTAS_ISSQN, 0) AS VLR_ISENTAS_ISSQN,
            ISNULL(TRIB.VLR_N_INCIDENCIA, 0)  AS VLR_N_INCIDENCIA,
            ISNULL(TRIB.VLR_N_INCIDENCIA_ISSQN, 0) AS VLR_N_INCIDENCIA_ISSQN,
            ISNULL(TRIB.VLR_BASE_CALC_ICMS, 0) AS VLR_BASE_CALC_ICMS,
            ISNULL(TRIB_TAXAS.TX_ICMS_IT, 0) AS TX_ICMS_IT,
            ISNULL(TRIB_TAXAS.VLR_IMPOSTO, 0) AS VLR_IMPOSTO,
            ISNULL(TRIB_TAXAS.VLR_TOT_BASE, 0) AS VLR_TOT_BASE,
            ISNULL(TRIB.BASE_ISSQN, 0) BASE_ISSQN,
            ISNULL(SUM(VLR_LIQ_IT) + (SUM(TEMP.VLR_IT_CANCEL)) + SUM(temp.VLR_CUPONS_CANCELADOS) + SUM(TEMP.VLR_IT_CANCEL_ISSQN) + SUM(TEMP.VLR_CUPONS_CANCELADOS_ISSQN) + ISNULL(TRIB.BASE_ISSQN, 0)
          + SUM(temp.VLR_DESC_IT) + SUM(TEMP.VLR_DESC), 0) + SUM(TEMP.VLR_DESC_IT_ISSQN) + SUM(TEMP.VLR_DESC_ISSQN)
          + ISNULL(TRIB.VLR_N_INCIDENCIA_ISSQN, 0) + ISNULL(TRIB.VLR_ISENTAS_ISSQN, 0)  AS VLR_VENDA_BRUTA,
            SUM(VLR_LIQ_IT) - ISNULL(SUM(TEMP.VLR_DESC_ISSQN), 0) AS VLR_LIQ_IT,
            ISNULL(TRIB_TAXAS.TIPO_IMPOSTO, 0) AS TIPO_IMPOSTO
     
     FROM
     (
         SELECT C.CD_EMP,
                C.CD_FILIAL,
                C.CD_CX,
                C.CD_VD,
                C.DT_VD,
                C.NR_ECF AS COO,
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 0
                    THEN SUM(I.VLR_DESC_TOT_RAT)
                    ELSE 0
                END AS VLR_DESC, --  DESCONTO RATEIO CABEALHO
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 1
                    THEN SUM(I.VLR_DESC_TOT_RAT)
                    ELSE 0
                END AS VLR_DESC_ISSQN, --  DESCONTO RATEIO CABEALHO
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 0
                    THEN ISNULL(SUM(I.TOT_IT - I.VLR_DESC_TOT_RAT), 0)
                    ELSE 0
                END AS VLR_CONTAB,
                CASE
                    WHEN C.ST_VD = 0
                    THEN ISNULL(SUM(I.TOT_IT - I.VLR_DESC_TOT_RAT), 0)
                    ELSE 0
                END AS VLR_VENDA_BRUTA,
                ISNULL(
                      (
                          SELECT ISNULL(SUM(I.QT_IT * I.VLR_IT), 0)
                          FROM PDV_VD_IT IT
                          WHERE I.CD_EMP = IT.CD_EMP
                                AND I.CD_FILIAL = IT.CD_FILIAL
                                AND I.CD_VD = IT.CD_VD
                                AND I.CD_IT = IT.CD_IT
                                AND IT.ST_IT = 2
                                AND C.ST_VD = 0
                                AND ISNULL(TIPO_IMPOSTO, 0) = 0
                      ), 0) AS VLR_IT_CANCEL,
                ISNULL(
                      (
                          SELECT ISNULL(SUM(I.QT_IT * I.VLR_IT), 0)
                          FROM PDV_VD_IT IT
                          WHERE I.CD_EMP = IT.CD_EMP
                                AND I.CD_FILIAL = IT.CD_FILIAL
                                AND I.CD_VD = IT.CD_VD
                                AND I.CD_IT = IT.CD_IT
                                AND IT.ST_IT = 2
                                AND C.ST_VD = 0
                                AND ISNULL(TIPO_IMPOSTO, 0) = 1
                      ), 0) AS VLR_IT_CANCEL_ISSQN,
                ISNULL(
                      (
                          SELECT ISNULL(SUM((I.QT_IT * I.VLR_IT)), 0)
                          FROM PDV_VD VD
                          WHERE VD.CD_EMP = C.CD_EMP
                                AND VD.CD_FILIAL = C.CD_FILIAL
                                AND VD.CD_VD = C.CD_VD
                                AND VD.DT_VD = C.DT_VD
                                AND C.ST_VD = 1
                                AND ISNULL(TIPO_IMPOSTO, 0) = 0
                      ), 0) AS VLR_CUPONS_CANCELADOS,
                ISNULL(
                      (
                          SELECT ISNULL(SUM((I.QT_IT * I.VLR_IT)), 0)
                          FROM PDV_VD VD
                          WHERE VD.CD_EMP = C.CD_EMP
                                AND VD.CD_FILIAL = C.CD_FILIAL
                                AND VD.CD_VD = C.CD_VD
                                AND VD.DT_VD = C.DT_VD
                                AND C.ST_VD = 1
                                AND ISNULL(TIPO_IMPOSTO, 0) = 1
                      ), 0) AS VLR_CUPONS_CANCELADOS_ISSQN,
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 0
                    THEN ISNULL(SUM(ROUND(((I.QT_IT * I.VLR_IT) * I.TX_DESC / 100), 2)), 0)
                    ELSE 0
                END AS VLR_DESC_IT, -- DESCONTO NO ITEM 
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 1
                    THEN ISNULL(SUM(ROUND(((I.QT_IT * I.VLR_IT) * I.TX_DESC / 100), 2)), 0)
                    ELSE 0
                END AS VLR_DESC_IT_ISSQN, -- DESCONTO NO ITEM 
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 0
                    THEN ISNULL(SUM(I.TOT_IT - I.VLR_DESC_TOT_RAT), 0)
                    ELSE 0
                END AS VLR_LIQ_IT
         FROM PDV_VD C
              INNER JOIN PDV_VD_IT I ON C.CD_EMP = I.CD_EMP
                                        AND C.CD_FILIAL = I.CD_FILIAL
                                        AND C.CD_VD = I.CD_VD
                                        AND C.DT_VD = I.DT_VD
								WHERE ISNULL(C.TIPO ,0) = 0 
         --*********************************************************************************************************
         --where c.cd_filial = 12
         --and c.dt_vd = '20141206'
         --and c.cd_cx = 1
         --*********************************************************************************************************
         GROUP BY C.CD_EMP,
                  C.CD_FILIAL,
                  C.CD_CX,
                  C.CD_VD,
                  C.DT_VD,
                  C.NR_ECF,
                  C.VLR_DESC,
                  C.ST_VD,
                  I.ST_IT,
                  I.CD_EMP,
                  I.CD_FILIAL,
                  I.CD_IT,
                  I.CD_VD,
                  I.TIPO_IMPOSTO
         UNION ALL
         SELECT C.CD_EMP,
                C.CD_FILIAL,
                C.CD_CX,
                C.CD_VD,
                C.DT_VD,
                C.NR_ECF AS COO,
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 0
                    THEN SUM(I.VLR_DESC_TOT_RAT)
                    ELSE 0
                END AS VLR_DESC,
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                         AND ISNULL(TIPO_IMPOSTO, 0) = 1
                    THEN SUM(I.VLR_DESC_TOT_RAT)
                    ELSE 0
                END AS VLR_DESC_ISSQN,
                CASE
                    WHEN C.ST_VD = 0
                         AND I.ST_IT = 1
                    THEN ISNULL(SUM(I.TOT_IT - I.VLR_DESC_TOT_RAT), 0)
                    ELSE 0
                END AS VLR_CONTAB,
                CASE
                    WHEN C.ST_VD = 0
                    THEN ISNULL(SUM(I.TOT_IT - I.VLR_DESC_TOT_RAT), 0)
                    ELSE 0
                END AS VLR_VENDA_BRUTA,
                0 AS VLR_IT_CANCEL,
                0 AS VLR_IT_CANCEL_ISSQN,
                SUM(C.VLR_LIQ_VD) AS VLR_CUPONS_CANCELADOS,
                0 AS VLR_CUPONS_CANCELADOS_ISSQN, -- ?
                0 AS VLR_DESC_IT,
                0 AS VLR_DESC_IT_ISSQN,
                0 AS VLR_LIQ_IT
         FROM PDV_VD C
              LEFT JOIN PDV_VD_IT I ON C.CD_EMP = I.CD_EMP
                                       AND C.CD_FILIAL = I.CD_FILIAL
                                       AND C.CD_VD = I.CD_VD
         WHERE C.ST_VD = 1
               AND I.CD_VD IS NULL
         --*******************************************************************************************************
         --AND c.cd_filial = 12
         --and c.dt_vd = '20141206'
         --and c.cd_cx = 1
         --*********************************************************************************************************
         GROUP BY C.CD_EMP,
                  C.CD_FILIAL,
                  C.CD_CX,
                  C.CD_VD,
                  C.DT_VD,
                  C.NR_ECF,
                  C.VLR_DESC,
                  C.ST_VD,
                  I.ST_IT,
                  I.CD_EMP,
                  I.CD_FILIAL,
                  I.CD_IT,
                  I.CD_VD,
                  I.TIPO_IMPOSTO
     ) AS TEMP
     LEFT JOIN V_PDV_VD_TRIBUTOS TRIB ON TEMP.CD_EMP = TRIB.CD_EMP
                                         AND TEMP.CD_FILIAL = TRIB.CD_FILIAL
                                         AND TEMP.CD_CX = TRIB.CD_CX
                                         AND TEMP.DT_VD = TRIB.DT_VD
     LEFT JOIN PDV_POS_DIARIA_ECF POS_ECF ON TEMP.CD_EMP = POS_ECF.CD_EMP
                                             AND TEMP.CD_FILIAL = POS_ECF.CD_FILIAL
                                             AND TEMP.CD_CX = POS_ECF.CD_CX
                                             AND TEMP.DT_VD = POS_ECF.DT_MOV
     LEFT JOIN
     (
         SELECT CD_EMP,
                CD_FILIAL,
                CD_CX,
                DT_VD,
                SUM(VLR_TOT_BASE) AS VLR_TOT_BASE,
                TX_ICMS_IT AS TX_ICMS_IT,
                SUM(VLR_IMPOSTO) AS VLR_IMPOSTO,
                TIPO_IMPOSTO
         FROM V_PDV_VD_TRIBUTOS_TAXAS
         GROUP BY CD_EMP,
                  CD_FILIAL,
                  CD_CX,
                  DT_VD,
                  TIPO_IMPOSTO,
			   TX_ICMS_IT
     ) TRIB_TAXAS ON TEMP.CD_EMP = TRIB_TAXAS.CD_EMP
                     AND TEMP.CD_FILIAL = TRIB_TAXAS.CD_FILIAL
                     AND TEMP.CD_CX = TRIB_TAXAS.CD_CX
                     AND TEMP.DT_VD = TRIB_TAXAS.DT_VD
     GROUP BY TEMP.CD_EMP,
              TEMP.CD_FILIAL,
              TEMP.CD_CX,
              TEMP.DT_VD,
              POS_ECF.CONT_REDUCAO_Z,
              POS_ECF.CONT_REINICIO_OP,
              POS_ECF.VLR_GT_INI,
              POS_ECF.VLR_GT_FIN,
              TRIB.VLR_SUBST_TRIB,
              TRIB.VLR_ISENTAS,
              TRIB.VLR_N_INCIDENCIA,
              TRIB.VLR_BASE_CALC_ICMS,
              TRIB.VLR_IMPOSTO,
              TRIB_TAXAS.TX_ICMS_IT,
              TRIB_TAXAS.VLR_TOT_BASE,
              TRIB_TAXAS.TIPO_IMPOSTO,
              TRIB.BASE_ISSQN,
              TRIB.VLR_N_INCIDENCIA_ISSQN,
              TRIB.VLR_ISENTAS_ISSQN,
			  TRIB_TAXAS.VLR_IMPOSTO

		